#if (!requireNamespace("BiocManager", quietly = TRUE))
#    install.packages("BiocManager")
#BiocManager::install("limma")


library(limma)           #library package
expFile="TCGA.TPM_log.txt"      #expression data file
geneFile="gene.txt"      #gene list file
setwd("D:\\metabolism\\LGG\\3.Subtype")   

#Read the input file and process the data
rt=read.table(expFile, header=T, sep="\t", check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0,]

#Obtain the expression level of metabolism key genes
gene=read.table(geneFile, header=T, sep="\t", check.names=F)
sameGene=intersect(as.vector(gene[,1]), rownames(data))
geneExp=data[sameGene,]

#output result
out=rbind(ID=colnames(geneExp),geneExp)
write.table(out,file="metabolismGeneExp.txt",sep="\t",quote=F,col.names=F)